#include "c4d_memory.h"
#include "c4d_baselist.h"
#include "c4d_nodeplugin.h"

VariableChanged::VariableChanged(void)
{
	old_cnt=new_cnt=0;
	map=NULL;
	safety=TRUE;
}

void BaseList2D::ToggleBit(LONG mask)
{
	LONG bitfield = C4DOS.Bl->GetAllBits(this);

	if (bitfield & mask) 
		bitfield = bitfield & ~mask; 
	else 
		bitfield = bitfield | mask; 

	C4DOS.Bl->SetAllBits(this,bitfield);
}

void GeListNode::SetCustomData(GeListNode *node)
{
	C4DOS.Bl->SetCustomData(this,node);
}

GeListNode*	GeListNode::GetCustomData(void)
{
	return C4DOS.Bl->GetCustomData(this);
}

LONG BaseList2D::GetColor(void) 
{
	return C4DOS.Bl->GetColor(this);	
}

void BaseList2D::SetColor(LONG c)
{
	C4DOS.Bl->SetColor(this,c);	
}

Bool Atom::Read(HyperFile *hf, LONG id, LONG level)
{
	return C4DOS.Bl->Read(this,hf,id,level);
}

Bool Atom::Write(HyperFile *hf)
{
	return C4DOS.Bl->Write(this,hf);
}

Bool Atom::ReadObject(HyperFile *hf, Bool readheader)
{
	return C4DOS.Bl->ReadObject(this,hf,readheader);
}

Bool Atom::WriteObject(HyperFile *hf)
{
	return C4DOS.Bl->WriteObject(this,hf);
}

Bool Atom::GetDescription(Description *description,LONG flags)
{
	return AtCall(GetDescription)(*description,flags);
}

Bool Atom::GetParameter(const DescID &id,GeData &data,LONG flags)
{
	return AtCall(GetParameter)(id,data,flags);
}

Bool Atom::SetParameter(const DescID &id,const GeData &data,LONG flags)
{
	return AtCall(SetParameter)(id,data,flags);
}

Bool BaseList2D::SetAnimatedParameter(const DescID &id,const GeData &t_data1,const GeData &t_data2,Real mix,LONG flags)
{
	return AtCall(SetAnimatedParameter)(id,t_data1,t_data2,mix,flags);
}

Bool BaseList2D::GetAnimatedParameter(const DescID &id,GeData &t_data1,GeData &t_data2,Real &mix,LONG flags)
{
	return AtCall(GetAnimatedParameter)(id,t_data1,t_data2,mix,flags);
}

DynamicDescription *Atom::GetDynamicDescription()
{
	return AtCall(GetDynamicDescription)();
}

GeListHead *AllocListHead(void)
{
	return C4DOS.Bl->AllocListHead();
}

GeListNode *AllocListNode(LONG id)
{
	return C4DOS.Bl->AllocListNode(0,&id,1);
}

GeListNode *AllocSmallListNode(LONG id)
{
	return C4DOS.Bl->AllocListNode(PLUGINFLAG_SMALLNODE,&id,1);
}

GeListNode *AllocMultiNode(LONG *id_array, LONG id_cnt)
{
	return C4DOS.Bl->AllocListNode(0,id_array,id_cnt);
}

BaseLink *BaseLink::Alloc(void)
{
	return C4DOS.Ln->Alloc();
}

void BaseLink::Free(BaseLink *&link)
{
	if (link) C4DOS.Ln->Free(link);
	link=NULL;
}

AliasTrans *AliasTrans::Alloc(void)
{
	return C4DOS.Ln->TrnAlloc();
}

void AliasTrans::Free(AliasTrans *&trn)
{
	if (trn) C4DOS.Ln->TrnFree(trn);
	trn=NULL;
}

GeListHead *GeListHead::Alloc(void)
{
	return C4DOS.Bl->AllocListHead();
}

void GeListHead::Free(GeListHead *&head)
{
	if (head) C4DOS.Bl->Free(head);
	head=NULL;
}

Bool BaseList2D::Edit(void)
{
	return C4DOS.Bo->Edit(this);
}

void BaseList2D::GetIcon(IconData *dat)
{
	C4DOS.Bo->GetIcon(this,dat);
}

LONG BaseList2D::GetInfo(void)
{
	return C4DOS.Bo->GetInfo(this);
}

BaseTrack	*BaseList2D::GetFirstTrack(void)
{
	return C4DOS.Bo->GetFirstTrack(this);
}

BaseTrack	*BaseList2D::GetTrack(LONG type)
{
	return C4DOS.Bo->GetTrack(this,type);
}

void BaseList2D::KillAllTracks(void)
{
	C4DOS.Bo->KillAllTracks(this);
}

void BaseList2D::InsertTrack(BaseTrack *track, BaseTrack *pred)
{
	C4DOS.Bo->InsertTrack(this,track,pred);
}

void BaseList2D::InsertTrackLast(BaseTrack *track)
{
	C4DOS.Bo->InsertTrackLast(this,track);
}

BaseTrack *BaseList2D::FindTrack(const DescID &id)
{
	return C4DOS.Bo->FindTrack(this,id);
}
